﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Diagnostics" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Ewidencja normy pracy</title>
		<script runat="server">
	
    abstract class Item: IComparable {
    
           public int CompareTo(object obj) {
               if (obj == null)
                   return 1;
               Item item = obj as Item;
               if (item == null)
                   throw new ArgumentException();
               return title.CompareTo(item.title);
           }
    
           public readonly string title;
           public readonly object[] dni = new object[31];
           public Time planCzas;
           public int planDni;
    
           protected Item(string title) {
               this.title = title;
           }
       }
    
       class PracItem: Item {

           public PracItem(Pracownik pracownik) : base(pracownik.ToString()) {
           }
           
           public Wydzial Fill(Pracownik pracownik, FromTo okres, Wydzial wydzial) {

				Periods zatr = Periods.Empty;
                Periods wgKalendarza = Periods.Empty;
               
				foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres)) {
					FromTo eo = ph.Etat.EfektywnyOkres * okres;
                    if (wydzial == null || wydzial == ph.Etat.Wydzial) {
                        zatr += eo;
                        if (ph.Etat.InterpretacjaKalendarza != InterpretacjaKalendarza.WgZestawien)
                            wgKalendarza += eo;
                    }
				}           
               
				zatr = zatr.ToFlat();
                wgKalendarza = wgKalendarza.ToFlat();
				
				if (zatr.Count == 0)
					return null;

                KalkulatorPracownika kalk = new KalkulatorPracownika(pracownik, null);

                foreach (FromTo zatrudniony in wgKalendarza)
                    foreach (Date data in zatrudniony) {
                        int i = data - okres.From;
                        if (dni[i] == null) {
                            Dzien dzieńPlanu = kalk.KalkPlanu[data];
                            dni[i] = dzieńPlanu.Czas.ToString();
                        }
                    }
                
                foreach (Date data in okres) {
                    int i = data - okres.From;
                    if (dni[i] == null)
                        dni[i] = "&nbsp;";
                }
               
                foreach (FromTo zatrudniony in zatr)
                    foreach (Dzien dp in kalk.KalkPlanu[zatrudniony]) {
                        planDni += dp.Dni;
                        planCzas += dp.Czas;
                    }

                Debug.Assert(pracownik[zatr.To].Etat.Wydzial != null);
                return pracownik[zatr.To].Etat.Wydzial;
           }
       }
    
       class SumItem: Item {
           public SumItem(string title): base(title) {
               for(int i = 0; i < 31; i++)
                   dni[i] = Time.Zero;
           }
           public void Add(Item item) {
               for(int i = 0; i < 31; i++)
                   if (item.dni[i] is Time)
                       dni[i] = (Time)dni[i] + (Time)item.dni[i];
    
               planDni += item.planDni;
               planCzas += item.planCzas;
           }
       }
    
       class WdzItem: SumItem {
           public WdzItem(Wydzial wdz): base(wdz.ToString()) {
           }
       }
    
       void FillRow(Item item) {
           title.EditValue = item.title;
           p1.EditValue =  item.dni[0];
           p2.EditValue =  item.dni[1];
           p3.EditValue =  item.dni[2];
           p4.EditValue =  item.dni[3];
           p5.EditValue =  item.dni[4];
           p6.EditValue =  item.dni[5];
           p7.EditValue =  item.dni[6];
           p8.EditValue =  item.dni[7];
           p9.EditValue =  item.dni[8];
           p10.EditValue = item.dni[9];
           p11.EditValue = item.dni[10];
           p12.EditValue = item.dni[11];
           p13.EditValue = item.dni[12];
           p14.EditValue = item.dni[13];
           p15.EditValue = item.dni[14];
           p16.EditValue = item.dni[15];
           p17.EditValue = item.dni[16];
           p18.EditValue = item.dni[17];
           p19.EditValue = item.dni[18];
           p20.EditValue = item.dni[19];
           p21.EditValue = item.dni[20];
           p22.EditValue = item.dni[21];
           p23.EditValue = item.dni[22];
           p24.EditValue = item.dni[23];
           p25.EditValue = item.dni[24];
           p26.EditValue = item.dni[25];
           p27.EditValue = item.dni[26];
           p28.EditValue = item.dni[27];
           p29.EditValue = item.dni[28];
           p30.EditValue = item.dni[29];
           p31.EditValue = item.dni[30];
           
           dni.EditValue = item.planDni;
           czas.EditValue = item.planCzas;
       }
    
       FromTo okres;
       Wydzial wydzial;
    
       abstract class GridCaption {
           public abstract string Caption { get; }
           public abstract IEnumerable DataSource { get; }
       }
    
       class Prac: GridCaption {
           readonly Row[] rows;
           public override string Caption {
               get { return "Pracownik"; }
           }
           public Prac(Row[] rows) {
               this.rows = rows;
           }
           public override IEnumerable DataSource {
               get { return rows; }
           }
       }
       Prac prac;
    
       class Wydz: GridCaption {
           readonly Hashtable ht = new Hashtable();
           public override string Caption {
               get { return "Wydział"; }
           }
           public Wydz() {
           }
           public void Add(Wydzial wydzial, PracItem item) {
               SumItem sum = (SumItem)ht[wydzial];
               if (sum == null) {
                   sum = new WdzItem(wydzial);
                   ht.Add(wydzial, sum);
               }
               sum.Add(item);
           }
           public override IEnumerable DataSource {
               get {
                   ArrayList list = new ArrayList(ht.Values);
                   list.Sort();
                   return list;
               }
           }
       }
       Wydz wydz;
    
       class Razem: GridCaption {
           readonly SumItem item = new SumItem("Razem");
           public override string Caption {
               get { return "Razem"; }
           }
           public Razem() {
           }
           public void Add(PracItem item) {
               this.item.Add(item);
           }
           public override IEnumerable DataSource {
               get { return new object[] { item }; }
           }
       }
       Razem raz;
    
       public class PrnParams: ContextBase {
           public PrnParams(Context context): base(context) {
               Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
               ym = new YearMonth(data);
           }
           YearMonth ym;
           [Required]
           [Priority(1)]
           public YearMonth Miesiąc {
               get { return ym; }
               set {
                   ym = value;
                   OnChanged(EventArgs.Empty);
               }
           }
           Wydzial wydzial;
           [Priority(2)]
           [Browsable(true)]
           public Wydzial Wydzial {
               get { return wydzial; }
               set { 
				   wydzial = value; 
                   OnChanged(EventArgs.Empty);
				}
           }           
           bool pracownicy = true;
           [Priority(3)]
           public bool Pracownicy {
               get { return pracownicy; }
               set { 
					pracownicy = value; 
					OnChanged(EventArgs.Empty);
				}
           }
           bool wydziały = false;
           [Priority(4)]
           public bool Wydziały {
               get { return wydziały; }
               set { 
				   wydziały = value; 
                   OnChanged(EventArgs.Empty);
			   }
           }
           bool razem = false;
           [Priority(5)]
           public bool Razem {
               get { return razem; }
               set { 
				   razem = value; 
                   OnChanged(EventArgs.Empty);
				}
           }
	   }
	            
       PrnParams pars;
       [Context(Required=true)]
       public PrnParams Params {
           get { return pars; }
           set { pars = value; }
       }

       void OnContextLoad(Object sender, EventArgs args) {
           ReportHeader1["MIESIĄC"] = pars.Miesiąc.ToString();
           ReportHeader1["WYDZIAŁ"] = pars.Wydzial==null ? "" : "</strong>Wydział: <strong>" + pars.Wydzial.ToString();
           okres = pars.Miesiąc.ToFromTo();
           wydzial = pars.Wydzial;
           prac = new Prac((Row[])dc[typeof(Row[])]);
           wydz = new Wydz();
           raz = new Razem();
    
           ArrayList al = new ArrayList();
           if (pars.Pracownicy)
               al.Add(prac);
           else if(pars.Wydziały || pars.Razem)
               foreach (Pracownik p in prac.DataSource)
                   NewItem(p);
    
           if (pars.Wydziały)
               al.Add(wydz);
    
           if (pars.Razem)
               al.Add(raz);
    
           DataRepeater1.DataSource = al;
       }
    
       void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
           GridCaption gc = (GridCaption)DataRepeater1.CurrentRow;
           title.Caption = gc.Caption;
       }

        PracItem NewItem(Pracownik prac) {
            PracItem item = new PracItem(prac);
            Wydzial w = item.Fill(prac, okres, wydzial);
            if (w == null)
                return null;
            wydz.Add(w, item);
            raz.Add(item);
            return item;
        }
    
        void Grid1_BeforeRow(Object sender, RowEventArgs args) {
               object obj = args.Row;
               if (obj is Pracownik) {
                   PracItem item = NewItem((Pracownik)obj);
                   if (item != null)
				       FillRow(item);
			       else
			           args.VisibleRow = false;
               }
               else
                   FillRow((SumItem)obj);
        }

        public static void Msg(object obj) {
        }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="EwidencjaCzasuPracy" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" Landscape="true" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Norma czasu pracy za %MIESIĄC%|%WYDZIAŁ%" runat="server"></cc1:reportheader>
            <ea:datarepeater id="DataRepeater1" runat="server" Width="100%" OnBeforeRow="DataRepeater1_BeforeRow">
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
				<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" DataMember="DataSource"
					RowsInRow="3">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" " RowSpan="3"></ea:GridColumn>
						<ea:GridColumn ColSpan="17" BottomBorder="Single" Align="Left" Caption="Pracownik" ID="title"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="1" ID="p1"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="16" ID="p16"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="2" ID="p2"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="17" ID="p17"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="3" ID="p3"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="18" ID="p18"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="4" ID="p4"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="19" ID="p19"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="5" ID="p5"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="20" ID="p20"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="6" ID="p6"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="21" ID="p21"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="7" ID="p7"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="22" ID="p22"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="8" ID="p8"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="23" ID="p23"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="9" ID="p9"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="24" ID="p24"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="10" ID="p10"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="25" ID="p25"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="11" ID="p11"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="26" ID="p26"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="12" ID="p12"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="27" ID="p27"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="13" ID="p13"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="28" ID="p28"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="14" ID="p14"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="29" ID="p29"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="15" ID="p15"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="30" ID="p30"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="X"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="31" ID="p31"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="Dni" ID="dni"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" Align="Right" Caption="Godz." ID="czas"></ea:GridColumn>
					</Columns>
				</ea:grid>
			</ea:datarepeater><cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter></form>
	</body>
</HTML>
